#!/bin/ksh
# $Id: depend.sh,v 1.9 2001/03/10 22:21:32 schmuck Exp $
## ###################################################################### ##
##        Copyright IBM 1993                                              ##
## ###################################################################### ##

#set nonomatch
################################################
if [ $# -lt 2 ] || [ $# -gt 5 ]; then
  echo 'usage: depends $DEPEND $INCLUDES [$DEFINES [$KDEFINES [$PKDEFINES]]]'
  exit 1
fi
################################################
DEPEND="$1"
INCLUDES="$2"
DEFINES="$3"
KDEFINES="$4"
PKDEFINES="$5"

################################################
CFILES=$(/bin/ls *.[cC])
if [ "$CFILES" = "" ]; then
  echo "No Dependencies to Check ...continuing...."
  exit 0
fi
################################################
CDEPENDS=/tmp/Dep1_$$
DEPENDERR=/tmp/Dep2_$$
DEPENDS=.depends
################################################

# make backup copy of makefile and remove old dependencies
mv makefile makefile.BAK
sed -n -e '1,/##### DEPENDENCY LINE - DO NOT DELETE #####/p' makefile.BAK > makefile

# run the compiler with option to generate dependencies
# output goes into $CDEPENDS, error messages go into $DEPENDERR
if [[ $DEFINES = *GPFS_LINUX* ]]
then
   rm -f *.d >/dev/null 2>&1
   g++ -w -MD -E >/dev/null $DEFINES $INCLUDES $CFILES 2> $DEPENDERR
   echo "" > $CDEPENDS
   cat *.d >> $CDEPENDS
   rm -f *.d >/dev/null 2>&1
else
   rm -f *.u >/dev/null 2>&1
   xlC_r -qonce -M -E >/dev/null $DEFINES $INCLUDES $CFILES 2> $DEPENDERR
   echo "" > $CDEPENDS
   cat *.u >> $CDEPENDS
   rm -f *.u >/dev/null 2>&1
fi

# show error messages, but filter out certain uninteresting messages
fgrep -v -e 'unknown directive == "#error' \
         -e 'Option lm is not valid' \
         -e 'Suboption compat is not valid for option langlvl' $DEPENDERR

# Copy output to $DEPENDS
"cp" $CDEPENDS $DEPENDS

# remove temporary output files
for i in $CDEPENDS $DEPENDERR
do
  rm -f $i $i.bak
done

# On Linux, if $KDEFINES is non-empty, certain files need to be compiled
# twice: once without and once with $KDEFINES to generate .ko file to
# be linked into kernel code.  If this is the case, we need to generate
# dependencies for the .ko files.
if [[ $DEFINES = *GPFS_LINUX* ]] && [ "$KDEFINES" != "" ]
then
  # generate dependencies with $KDEFINES
  rm -f *.d >/dev/null 2>&1
  g++ -w -MD -E >/dev/null $KDEFINES $INCLUDES $CFILES 2> $DEPENDERR
  echo "" > $CDEPENDS
  cat *.d >> $CDEPENDS
  rm -f *.d >/dev/null 2>&1

  # show error messages, but filter out certain uninteresting messages
  fgrep -v -e 'unknown directive == "#error' \
           -e 'Suboption compat is not valid for option langlvl' $DEPENDERR

  # Append output to $DEPENDS, but change ".o:" to ".ko:"
  sed -e 's/\.o:/.ko:/g' $CDEPENDS >> $DEPENDS

  # remove temporary output files
  for i in $CDEPENDS $DEPENDERR
  do
    rm -f $i $i.bak
  done
fi

# On Linux, if $PKDEFINES is non-empty, also generate dependencies
# for .pko files.
if [[ $DEFINES = *GPFS_LINUX* ]] && [ "$PKDEFINES" != "" ]
then
  # generate dependencies with $KDEFINES and $PKDEFINES
  rm -f *.d >/dev/null 2>&1
  g++ -w -MD -E >/dev/null $KDEFINES $PKDEFINES $INCLUDES $CFILES 2> $DEPENDERR
  echo "" > $CDEPENDS
  cat *.d >> $CDEPENDS
  rm -f *.d >/dev/null 2>&1

  # show error messages, but filter out certain uninteresting messages
  fgrep -v -e 'unknown directive == "#error' \
           -e 'Suboption compat is not valid for option langlvl' $DEPENDERR

  # Append output to $DEPENDS, but change ".o:" to ".pko:"
  sed -e 's/\.o:/.pko:/g' $CDEPENDS >> $DEPENDS

  # remove temporary output files
  for i in $CDEPENDS $DEPENDERR
  do
    rm -f $i $i.bak
  done
fi

# append all the dependencies to the makefile
cat $DEPENDS >> makefile
